from flask import Flask, request, jsonify, render_template
import sqlite3
from werkzeug.exceptions import BadRequest

app = Flask(__name__)

# Database configuration
DATABASE = 'databases/maalemap.db'

def get_db_connection():
    conn = sqlite3.connect(DATABASE)
    conn.row_factory = sqlite3.Row  # Return rows as dictionaries
    return conn

@app.route('/')
def home():
    return render_template('index.html')

@app.route('/search', methods=['GET'])
def search():
    query = request.args.get('q', '').strip()
    
    if not query or len(query) < 2:
        raise BadRequest('Please enter at least 2 characters')
    
    try:
        conn = get_db_connection()
        cursor = conn.cursor()
        
        # Search in addresses (modify based on your actual DB schema)
        cursor.execute("""
            SELECT * FROM addresses 
            WHERE address LIKE ? 
            LIMIT 20
        """, (f'%{query}%',))
        
        results = [dict(row) for row in cursor.fetchall()]
        conn.close()
        
        return jsonify({
            'success': True,
            'results': results
        })
    
    except sqlite3.Error as e:
        return jsonify({
            'success': False,
            'error': str(e)
        }), 500

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5000, debug=True)